package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.campaign.ids.Stats;
import com.fs.starfarer.api.impl.combat.PhaseCloakStats;
import java.awt.Color;

public class SWP_BossCloakStats extends PhaseCloakStats {

    @SuppressWarnings("FieldNameHidesFieldInSuperclass")
    private static final Color JITTER_COLOR = new Color(255, 0, 100, 255);

    @SuppressWarnings("FieldNameHidesFieldInSuperclass")
    private static final float MAX_TIME_MULT = 4f;

    public static float getMaxTimeMult(MutableShipStatsAPI stats) {
        return 1f + (MAX_TIME_MULT - 1f) * stats.getDynamic().getValue(Stats.PHASE_TIME_BONUS_MULT);
    }

    protected Object JITTERKEY1 = new Object();
    protected Object JITTERKEY2 = new Object();

    @Override
    public void apply(MutableShipStatsAPI stats, String id, State state, float effectLevel) {
        ShipAPI ship;
        boolean player;
        String actualId = id;
        if (stats.getEntity() instanceof ShipAPI) {
            ship = (ShipAPI) stats.getEntity();
            player = ship == Global.getCombatEngine().getPlayerShip();
            actualId = actualId + "_" + ship.getId();
        } else {
            return;
        }

        if (player) {
            maintainStatus(ship, effectLevel);
        }

        if (Global.getCombatEngine().isPaused()) {
            return;
        }

        if (state == State.COOLDOWN || state == State.IDLE) {
            unapply(stats, actualId);
            return;
        }

        float level = effectLevel;

        float jitterRangeBonus = 0f;
        float levelForAlpha = level;

        stats.getMaxSpeed().modifyFlat(actualId, 25f * effectLevel);
        stats.getMaxSpeed().modifyPercent(actualId, 25f * effectLevel);
        stats.getAcceleration().modifyFlat(actualId, 25f * effectLevel);
        stats.getAcceleration().modifyPercent(actualId, 100f * effectLevel);
        stats.getDeceleration().modifyFlat(actualId, 10f * effectLevel);
        stats.getDeceleration().modifyPercent(actualId, 40f * effectLevel);
        stats.getTurnAcceleration().modifyFlat(actualId, 25f * effectLevel);
        stats.getTurnAcceleration().modifyPercent(actualId, 50f * effectLevel);
        stats.getMaxTurnRate().modifyFlat(actualId, 25f * effectLevel);
        stats.getMaxTurnRate().modifyPercent(actualId, 50f * effectLevel);

        ship.setPhased(true);

        ship.setJitter(JITTERKEY1, JITTER_COLOR, level * 0.5f, 1, 0, 0 + jitterRangeBonus);
        ship.setJitterUnder(JITTERKEY2, JITTER_COLOR, level * 0.5f, 11, 0f, 7f + jitterRangeBonus);
        ship.setExtraAlphaMult(1f - (1f - SHIP_ALPHA_MULT) * levelForAlpha);
        ship.setApplyExtraAlphaToEngines(true);

        float shipTimeMult = 1f + (getMaxTimeMult(stats) - 1f) * levelForAlpha;
        stats.getTimeMult().modifyMult(actualId, shipTimeMult);
        if (player) {
            Global.getCombatEngine().getTimeMult().modifyMult(actualId, 1f / shipTimeMult);
        } else {
            Global.getCombatEngine().getTimeMult().unmodify(actualId);
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship;
        if (stats.getEntity() instanceof ShipAPI) {
            ship = (ShipAPI) stats.getEntity();
        } else {
            return;
        }

        Global.getCombatEngine().getTimeMult().unmodify(id);
        stats.getTimeMult().unmodify(id);

        ship.setPhased(false);
        ship.setExtraAlphaMult(1f);

        stats.getMaxSpeed().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
    }

    private void maintainStatus(ShipAPI playerShip, float effectLevel) {
        float level = effectLevel;
        float f = VULNERABLE_FRACTION;

        ShipSystemAPI cloak = playerShip.getPhaseCloak();
        if (cloak == null) {
            cloak = playerShip.getSystem();
        }
        if (cloak == null) {
            return;
        }

        if (level > f) {
            Global.getCombatEngine().maintainStatusForPlayerShip(STATUSKEY2,
                                                                 cloak.getSpecAPI().getIconSpriteName(),
                                                                 cloak.getDisplayName(), "time flow altered", false);
        }
    }

}
